import { T } from "@tldraw/validate";
import { canvasUiColorTypeValidator } from "./TLColor.mjs";
import { vecModelValidator } from "./geometry-types.mjs";
const TL_SCRIBBLE_STATES = /* @__PURE__ */ new Set(["starting", "paused", "active", "stopping"]);
const scribbleValidator = T.object({
  id: T.string,
  points: T.arrayOf(vecModelValidator),
  size: T.positiveNumber,
  color: canvasUiColorTypeValidator,
  opacity: T.number,
  state: T.setEnum(TL_SCRIBBLE_STATES),
  delay: T.number,
  shrink: T.number,
  taper: T.boolean
});
export {
  TL_SCRIBBLE_STATES,
  scribbleValidator
};
//# sourceMappingURL=TLScribble.mjs.map
